'use client';

import { useRestaurantInfo } from '@/hooks/use-restaurant-info';
import { useEffect, type ReactNode } from 'react';

export function ThemeProvider({ children }: { children: ReactNode }) {
  const { restaurantInfo, isLoaded } = useRestaurantInfo();

  useEffect(() => {
    if (isLoaded) {
      const root = document.documentElement;
      root.style.setProperty('--primary', restaurantInfo.colors.primary);
      root.style.setProperty('--background', restaurantInfo.colors.background);
      root.style.setProperty('--accent', restaurantInfo.colors.accent);
      root.style.setProperty('--foreground', restaurantInfo.colors.foreground);
      root.style.setProperty('--card', restaurantInfo.colors.card);
      root.style.setProperty('--card-foreground', restaurantInfo.colors.cardForeground);
      root.style.setProperty('--muted-foreground', restaurantInfo.colors.mutedForeground);
    }
  }, [isLoaded, restaurantInfo.colors]);

  return <>{children}</>;
}
